////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN

@class PasswordError;

/**
 * Interface to implement in order to receive events related to local transaction.
 */
NS_REFINED_FOR_SWIFT
@protocol LocalTransactionDelegate <NSObject>

/**
 * Called upon local transaction success.
 *
 * @param signature the generated signature
 * @param hostCode  the generated host code
 */
- (void)onLocalTransactionSuccess:(NSString *)signature hostCode:(NSString  * _Nullable)hostCode;

/**
 * Called upon local transaction abortion
 */
- (void)onLocalTransactionAborted;

/**
 * Called upon password error when performing local transaction.
 *
 * @param error the type of password error
 */
- (void)onLocalTransactionPasswordError:(PasswordError *)error;

@end

NS_ASSUME_NONNULL_END
